---
title: Transform HTML quickly with streaming content · Changelog
description: HTMLRewriter now supports streamed content for more efficient
  replacement of HTML elements
chatbotDeprioritize: true
source_url:
  html: https://developers.cloudflare.com/changelog/2025-01-31-html-rewriter-streaming/
  md: https://developers.cloudflare.com/changelog/2025-01-31-html-rewriter-streaming/index.md
---

# Changelog

New updates and improvements at Cloudflare.

[Subscribe to RSS](https://developers.cloudflare.com/changelog/rss/index.xml)\
[View all RSS feeds](https://developers.cloudflare.com/fundamentals/new-features/available-rss-feeds/)

![hero image](https://developers.cloudflare.com/_astro/hero.CVYJHPAd_ZEA2nF.svg)

[← Back to all posts](https://developers.cloudflare.com/changelog/)

## Transform HTML quickly with streaming content

Jan 31, 2025

[Workers](https://developers.cloudflare.com/workers/)

You can now transform HTML elements with streamed content using [`HTMLRewriter`](https://developers.cloudflare.com/workers/runtime-apis/html-rewriter).

Methods like `replace`, `append`, and `prepend` now accept [`Response`](https://developers.cloudflare.com/workers/runtime-apis/response/) and [`ReadableStream`](https://developers.cloudflare.com/workers/runtime-apis/streams/readablestream/) values as [`Content`](https://developers.cloudflare.com/workers/runtime-apis/html-rewriter/#global-types).

This can be helpful in a variety of situations. For instance, you may have a Worker in front of an origin, and want to replace an element with content from a different source. Prior to this change, you would have to load all of the content from the upstream URL and convert it into a string before replacing the element. This slowed down overall response times.

Now, you can pass the `Response` object directly into the `replace` method, and HTMLRewriter will immediately start replacing the content as it is streamed in. This makes responses faster.

* JavaScript

  ```js
  class ElementRewriter {
    async element(element) {
      // able to replace elements while streaming content
      // the fetched body is not buffered into memory as part
      // of the replace
      let res = await fetch("https://upstream-content-provider.example");
      element.replace(res);
    }
  }


  export default {
    async fetch(request, env, ctx) {
      let response = await fetch("https://site-to-replace.com");
      return new HTMLRewriter()
        .on("[data-to-replace]", new ElementRewriter())
        .transform(response);
    },
  };
  ```

* TypeScript

  ```ts
  class ElementRewriter {
    async element(element: any) {
      // able to replace elements while streaming content
      // the fetched body is not buffered into memory as part
      // of the replace
      let res = await fetch('https://upstream-content-provider.example');
      element.replace(res);
    }
  }


  export default {
    async fetch(request, env, ctx): Promise<Response> {
      let response = await fetch('https://site-to-replace.com');
      return new HTMLRewriter().on('[data-to-replace]', new ElementRewriter()).transform(response);
    },
  } satisfies ExportedHandler<Env>;
  ```

For more information, see the [`HTMLRewriter` documentation](https://developers.cloudflare.com/workers/runtime-apis/html-rewriter).
