---
title: Create fully-managed RAG pipelines for your AI applications with AutoRAG
  · Changelog
description: AutoRAG lets you create fully-managed, retrieval-augmented
  generation (RAG) pipelines that continuously updates and scales on Cloudflare.
chatbotDeprioritize: true
source_url:
  html: https://developers.cloudflare.com/changelog/2025-04-07-autorag-open-beta/
  md: https://developers.cloudflare.com/changelog/2025-04-07-autorag-open-beta/index.md
---

# Changelog

New updates and improvements at Cloudflare.

[Subscribe to RSS](https://developers.cloudflare.com/changelog/rss/index.xml)\
[View all RSS feeds](https://developers.cloudflare.com/fundamentals/new-features/available-rss-feeds/)

![hero image](https://developers.cloudflare.com/_astro/hero.CVYJHPAd_ZEA2nF.svg)

[← Back to all posts](https://developers.cloudflare.com/changelog/)

## Create fully-managed RAG pipelines for your AI applications with AutoRAG

Apr 07, 2025

[AI Search ](https://developers.cloudflare.com/ai-search/)[Vectorize](https://developers.cloudflare.com/vectorize/)

[AutoRAG](https://developers.cloudflare.com/ai-search/) is now in open beta, making it easy for you to build fully-managed retrieval-augmented generation (RAG) pipelines without managing infrastructure. Just upload your docs to [R2](https://developers.cloudflare.com/r2/get-started/), and AutoRAG handles the rest: embeddings, indexing, retrieval, and response generation via API.

![AutoRAG open beta demo](https://developers.cloudflare.com/_astro/autorag-open-beta.Zs40SNMl_Zy2pju.webp)

With AutoRAG, you can:

* **Customize your pipeline:** Choose from [Workers AI](https://developers.cloudflare.com/workers-ai) models, configure chunking strategies, edit system prompts, and more.
* **Instant setup:** AutoRAG provisions everything you need from [Vectorize](https://developers.cloudflare.com/vectorize), [AI gateway](https://developers.cloudflare.com/ai-gateway), to pipeline logic for you, so you can go from zero to a working RAG pipeline in seconds.
* **Keep your index fresh:** AutoRAG continuously syncs your index with your data source to ensure responses stay accurate and up to date.
* **Ask questions:** Query your data and receive grounded responses via a [Workers binding](https://developers.cloudflare.com/ai-search/usage/workers-binding/) or [API](https://developers.cloudflare.com/ai-search/usage/rest-api/).

Whether you're building internal tools, AI-powered search, or a support assistant, AutoRAG gets you from idea to deployment in minutes.

Get started in the [Cloudflare dashboard](https://dash.cloudflare.com/?to=/:account/ai/autorag) or check out the [guide](https://developers.cloudflare.com/ai-search/get-started/) for instructions on how to build your RAG pipeline today.
