---
title: Custom rules · Cloudflare Web Application Firewall (WAF) docs
description: Custom rules allow you to control incoming traffic by filtering
  requests to a zone. They work as customized web application firewall (WAF)
  rules that you can use to perform actions like Block or Managed Challenge on
  incoming requests. You can also use the Skip action in a custom rule to skip
  one or more Cloudflare security features.
lastUpdated: 2025-09-22T16:52:07.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/waf/custom-rules/
  md: https://developers.cloudflare.com/waf/custom-rules/index.md
---

Custom rules allow you to control incoming traffic by filtering requests to a zone. They work as customized web application firewall (WAF) rules that you can use to perform actions like *Block* or *Managed Challenge* on incoming requests. You can also use the *Skip* action in a custom rule to [skip one or more Cloudflare security features](https://developers.cloudflare.com/waf/custom-rules/skip/).

In the [new security dashboard](https://developers.cloudflare.com/security/), custom rules are one of the available types of [security rules](https://developers.cloudflare.com/security/rules/). Security rules perform security-related actions on incoming requests that match specified filters.

Like other rules evaluated by Cloudflare's [Ruleset Engine](https://developers.cloudflare.com/ruleset-engine/), custom rules have the following basic parameters:

* An [expression](https://developers.cloudflare.com/ruleset-engine/rules-language/expressions/) that specifies the criteria you are matching traffic on using the [Rules language](https://developers.cloudflare.com/ruleset-engine/rules-language/).
* An [action](https://developers.cloudflare.com/ruleset-engine/rules-language/actions/) that specifies what to perform when there is a match for the rule.

Custom rules are evaluated in order, and some actions like *Block* will stop the evaluation of other rules. For more details on actions and their behavior, refer to the [actions reference](https://developers.cloudflare.com/ruleset-engine/rules-language/actions/).

To define sets of custom rules that apply to more than one zone, use [custom rulesets](https://developers.cloudflare.com/waf/account/custom-rulesets/), which require an Enterprise plan with a paid add-on.

## Availability

| | Free | Pro | Business | Enterprise |
| - | - | - | - | - |
| Availability | Yes | Yes | Yes | Yes |
| Number of rules | 5 | 20 | 100 | 1,000 |
| Supported actions | All except Log | All except Log | All except Log | All |
| Regex support | No | No | Yes | Yes |
| Custom rulesets | No | No | No | Paid add-on |

***

## Next steps

Refer to the following pages for instructions on creating custom rules:

* [Create a custom rule in the dashboard](https://developers.cloudflare.com/waf/custom-rules/create-dashboard/)
* [Create a custom rule via API](https://developers.cloudflare.com/waf/custom-rules/create-api/)
* [WAF custom rules configuration using Terraform](https://developers.cloudflare.com/terraform/additional-configurations/waf-custom-rules/)

For examples of using custom rules to address common use cases, refer to [Common use cases](https://developers.cloudflare.com/waf/custom-rules/use-cases/).
